<?php
/**
 * SocialBacklinks plugin for Facebook Social Network
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and change.
 * Otherwise, please feel free to contact us at contact@joomunited.com
 *
 * @package 	Social Backlinks
 * @copyright 	Copyright (C) 2012 JoomUnited (http://www.joomunited.com). All rights reserved.
 * @license 	GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */
 
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * SocialBacklinks plugin for Facebook Social Network
 */
class PlgSBVkAdapter extends  SBPluginsNetwork
{
	
	/**
	 * @see SBPluginsNetwork::__construct()
	 */
	public function __construct( $caller, $options = array() )
	{
		parent::__construct( $caller, array_merge( $options, array( 'window_size' => 'x:520,y:170' ) ) );
	}
	
	/**
	 * @see SBPluginsInterface::getAlias();
	 */
	public function getAlias( )
	{
		return 'vk';
	}

	/**
	 * Initializes and returns the Facebook object
	 * @return object
	 */
	protected function _getAdapter( )
	{
		if ( empty( $this->_adapter ) ) {
			$app = $this->_getApp( );
			$state = $this->_getState( );
			$this->_adapter = new VkSDK($app['app_id'], $app['secret'], 'https://oauth.vk.com/blank.html');

            if ($access_token = $this->getOption('access_token', FALSE)) {
                $this->_adapter->setAccessToken($access_token);
            }

            if ($user_id = $this->getOption('user_id', FALSE)) {
                $this->_adapter->setUserId($user_id);
            }
		}
		return $this->_adapter;
	}

	/**
	 * Returns array of the application data
	 * @throws SBPluginsException
	 * @return array
	 */
	protected function _getApp( )
	{

		if ( empty( $this->_app ) || empty($this->_app['app_id']) ) {
			if ( !($id = $this->app_id) || !($secret = $this->secret) ) {
			    $id = $this->getOption('app_id', null);
                $secret = $this->getOption('secret', null);
			}
			$this->_app = array(
				'app_id' => $id,
				'secret' => $secret
			);
		}

		return $this->_app;
	}

	/**
	 * Returns the list of the oauth states
	 * @return array
	 */
	protected function _getState( )
	{
		$app = $this->_getApp( );

		if ( empty( $this->_state ) ) {
			$app_id = $app['app_id'];

			if ( empty( $_SESSION["VkSDK"]["access_token"] ) ) {
				
				//Bgi: removed following clause
				//if ( empty( $this->access_token ) ) {
				//	return null;
				//}

				//Bgi: added if clause before setting state
				if ( !empty( $this->access_token ) ) {
					$state = array( 'access_token' => $this->access_token );
					$this->_setState( $state );
				}
			}
			else {
				$this->_state['access_token'] = $_SESSION["VkSDK"]["access_token"];
			}

			foreach ($this->getOptions() as $name => $value) {
				$this->_state[$name] = $value;
			}
		}

		return $this->_state;
	}

	/**
	 * Sets the oauth state
	 * @param  array $state
	 * @return void
	 */
	protected function _setState( $state )
	{
		$this->_state = $state;
		$app = $this->_getApp( );
		$_SESSION["VkSDK"]["access_token"] = $state["access_token"];
	}

	public function getUserName() {
		return 'vkUser';
	}
	
	/**
	 * Destroys custom data from session and in state
	 * @return void
	 */
	protected function _destroyState( )
	{
		try {
			$app = $this->_getApp( );
			if ( isset( $app['app_id'] ) && $id = $app['app_id'] ) {
				unset( $_SESSION["VkSDK"]["access_token"] );
			}
		}
		catch(SBPluginsException $e) {

		}
		$this->_state = array( );
	}

	/**
	 * Connects to Facebook network
	 * return result of the connection, or redirect otherwise
	 *
	 * @throws SBPluginsException if adapter was not found
	 * @param  array The list of connection parameters
	 * @param  boolean $callback Twitter server return some data
	 * @return boolean
	 */
	public function connect( $params, $callback = false )
	{
		if ( !$callback ) {
			$this->disconnect( true );
		}
		
		if ( !$vk = $this->_getAdapter( ) ) {
			throw new SBPluginsException( JText::sprintf( 'SB_NETWORK_CONNECT_ERROR', JText::_( 'SB_VK' ) ), 500 );
		}
		
		if ( !$callback ) {

			if (!($this->getOption('config_mode',0) > 0)) {
				// Automatic app info fetching	
				$url = 'http://prod.dev.joomunited.com/sbconnector/vkontakte/app-info';
				$rc = new RestClient();
				$data = $rc->HTTP($url, array(), 'GET');
				if ($data['Code'] == 200) {
					$info = json_decode($data['Response']);
					$this->setOption('app_id', $info->app_id);
					$this->setOption('secret', $info->app_secret);
                    $this->save();
					$this->app_id = $info->app_id;
					$this->secret = $info->app_secret;
					$this->_adapter = null;
					$vk = $this->_getAdapter();
				}
			}
				// Manual mode
				// Check if configured
				if ( !($id = $this->app_id) || !($secret = $this->secret) ) {
					throw new SBPluginsException( JText::_( 'SB_APP_DATA_ERROR' ), 500 );
				}
				$url = $vk->getLoginURL('offline,groups,wall');
?>

	    <script language="javascript">
	        function validateForm() {
	            if (document.forms['Form'].code_url.value.indexOf('https://oauth.vk.com/blank.html#code=') == -1)
	                return false;
	            else
	                return true;
	        }
	    </script>

	<h1>Social Backlinks</h1>
	<h2>Vk connector</h2>
	<hr />
	<h3>Now I need your help!</h3>
	<h3>Please click this <a href="<?php echo $url; ?>" target="_blank">LINK</a>, login to Vk and allow the app, then paste the URL of the final page below</h3>
	<form id="Form" method="post" onsubmit="return validateForm()" action="<?php echo $this->_getCallback(); ?>">
	    <label for="code_url">
	        Full address:
	        <input type="text" name="code_url" id="code_url" />
	        <br />https://oauth.vk.com/blank.html#code=...
	    </label>
	    <br />
	    <button id="submitButton" type="submit">
	        Continue...
	    </button>
	</form>
	<h4>Although the text in the pop-up tells you not to do so, we need the information to be able to publish on your site.</h4>
	<img src="<?php echo JURI::root(true) . '/media/com_socialbacklinks/images/vk_scr.png'; ?>" />
<?php			
		}
		else {
            if (isset($_POST['code_url'])) {
                list($url, $query_string) = explode('#', $_POST['code_url'], 2);
                parse_str($query_string, $parameters);
                if (empty($url) || empty($parameters['code'])) {
                    echo "You copied a wrong url. Please hit 'back', and try again.";
                    return;
                }
                $code = $parameters['code'];
                $vk->loginWithCode($code);
                $this->access_token = $vk->getAccessToken();
                $this->setOption('access_token', $this->access_token);
                $this->setOption('user_id', $vk->getUserId());
                $this->_adapter = null;
                $vk = $this->_getAdapter();
                $this->save();
                // Get communities
                $result = $vk->api('groups.get', array(
                    'extended' => 1,
                ));

                $communities = array();
                foreach($result->response as $community) {
                    if (!is_object($community))
                        continue;

                    $communities[] = (object) array ('id' => $community->gid, 'name' => $community->name);
                }
?>
                <h1>Social Backlinks</h1>
                <h2>Vk connector</h2>
                <hr />
                <h3>Select a community or your profile</h3>
                <form method="post" action="<?php echo $this->_getCallback(); ?>">
                    <select name="page_id">
                        <option value="0">My profile</option>
                        <?php foreach($communities as $community): ?>
                            <option value="<?php echo $community->id; ?>"><?php echo $community->name; ?></option>
                        <?php endforeach; ?>
                    </select>
                    <button type="submit">
                        Continue...
                    </button>
                </form>
<?php
                return;
            } else if (isset($_POST['page_id']) ) {
                $pageId = $_POST['page_id'];
                if ($pageId == 0) {
                    $this->setOption('post_target', 0);
                } else {
                    $this->setOption('post_target', 1);
                    $this->setOption('page_id', $pageId);
                    $this->setOption('post_as_admin', 1);
                }

            }

			if ( $vk->getUser( ) ) {
				// The user has been verified and the access tokens can be saved for future use
				$this->access_token = $vk->getAccessToken( );
				$this->save( );
				
				//$user = $facebook->getUser( );
				//echo '<pre>'; var_dump($user); echo '</pre>';
				
				return true;
			}
			else {
				$this->_destroyState( );
				throw new SBPluginsException( JText::sprintf( 'SB_NETWORK_CONNECT_ERROR', JText::_( 'SB_FACEBOOK' ) ), 500 );
				return false;
			}
		}
	}

	/**
	 * Disconnects from social network.
	 * @param  bool $callback Whether social server returns some data or not
	 * @return bool
	 */
	public function disconnect( $callback = false )
	{
		/*if ( !$callback ) {
			$facebook = $this->_getAdapter( );
			$url = $facebook->getLogoutUrl( array( 'next' => JURI::root() . html_entity_decode( $this->getLogoutUrl( ) ) . '&callback=1' ) );
			$app = JFactory::getApplication( );
			$app->redirect( $url );
		}
		else {*/
			// The user has been logged out from network
			$this->setOption( 'access_token', null );
            $this->setOption( 'user_id', null );
			$this->save( );
			$this->_destroyState( );
		/*}*/

		return true;
	}

	/**
	 * Checks if user is logged in Twitter network
	 * @return boolean
	 */
	public function isLoggedIn( )
	{
        $access_token = $this->getOption('access_token');
		return !empty($access_token);
	}

	/**
	 * Returns the Facebook user object if user data correct, or null otherwise
	 * @return mixed
	 */
	protected function _getUser( )
	{
		if ( empty( $this->_user ) ) {
			$vk = $this->_getAdapter( );

			if ( $user = $vk->getUser( ) ) {
				$this->_user = $user;
			}
			else {
				$this->_user = null;
			}
		}

		return $this->_user;
	}

	/**
	 * Adds post to user wall
	 * @param  string Title of the post
	 * @param  string Link to the items on User's site
	 * @param  string Description of the item
	 * @return boolean
	 */
	public function addPost( $title, $link, $desc = '', $image = '' )
	{
		if ( !$this->isLoggedIn( ) ) {
			throw new SBPluginsException( JText::_( 'SB_LOGIN_ERROR' ), 500 );
		}

		$vk = $this->_getAdapter( );

		$parameters = array(
			'message' => $title . ' - ' . $link,
			'v' => '5.0',
		);
		
		//$result = $this->_vk->api('wall.post', array(
        //    'owner_id' => '-'.$pageId,
        //    'from_group' => 1,
        //    'message' => 'hello world http://bgi.dev.joomunited.com/j25/index.php/16-test-article-image-plugin',
        //    'v' => '5.0',
        //));
		
		//if (!empty($image)) {
		//	$attachment['picture'] = $image;
		//}

		$state = $this->_getState( );

		// Send post
		try {
			// Possible variants of post target value
			// 0 - post to my profile
			// 1 - post to selected page
			// 2 - post to both
			if ( empty( $state['post_target'] ) || in_array( $state['post_target'], array(
				0,
				2
			) ) ) {
				// Add post on profile wall
				$result = $vk->api( 'wall.post', $parameters );
			}
			if ( !empty( $state['post_target'] ) && $state['post_target'] > 0 ) {
				if ( !empty( $state['page_id'] ) ) {
					// Add post on specified page
					$page_id = $state['page_id'];
					$parameters['owner_id'] = '-' . $page_id;
					if ( isset( $state['post_as_admin'] ) && $state['post_as_admin'] ) {
						$parameters['from_group'] = 1;
					}
					$result = $vk->api( "wall.post", $parameters );
					if ( isset($result->error) ) {
						throw new SBPluginsException($result->error->error_msg, 500);
					}
				}
				else {
					throw new SBPluginsException( JText::_( 'SB_VK_NO_PAGE_FOUND' ), 500 );
				}
			}
		}
		catch ( exception $e ) {
			if ( !$e instanceof SBPluginsException ) {
				$result = $e->getResult( );
				throw new SBPluginsException( $result['error']['message'], 500 );
			}
		}

		if ( $result && !isset($result->error)) {
			return true;
		}
		return false;
	}

}
