<?php
// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
/**
 * Created by JetBrains PhpStorm.
 * User: baudouin
 * Date: 9/11/13
 * Time: 2:00 PM
 * To change this template use File | Settings | File Templates.
 */

require_once('RestClient.php');

class VkSDK {

    private $_appId;
    private $_appSecret;
    private $_restClient;
    private $_accessToken;
    private $_redirectURI;
    private $_permissionScope;
    private $_userId;
    private $_expiresIn;
    private $_sessionKey = 'VkSDK';
    private $_authorizeURL = 'https://oauth.vk.com/authorize';
    private $_accessTokenURL = 'https://oauth.vk.com/access_token';
    private $_methodBaseURL = 'https://api.vk.com/method/';

    public function api($method, $parameters) {
        if (!isset($parameters['access_token']))
            $parameters['access_token'] = $this->getAccessToken();
        $result = $this->_restClient->HTTP($this->_methodBaseURL . $method, $parameters, 'POST');
        return json_decode($result['Response']);
    }

    public function getUser() {
        return $this->api('users.get', array(
            'user_ids' => $this->getUserId(),
            'v' => '5.0',
        ));
    }

    public function loginWithCode($code) {
        if (empty($code)) {
            throw new Exception("Invalid code. Check the code parameter is correct.");
        }

        $parameters = array(
            'client_id' => $this->_appId,
            'client_secret' => $this->_appSecret,
            'code' => $code,
            'redirect_uri' => $this->_redirectURI,
        );

        $result = $this->_restClient->HTTP($this->_accessTokenURL, $parameters, 'GET');

        if ($result['Code'] != 200) {
            throw new Exception("Unable to log in: " . $result['Response']);
        }

        $response = json_decode($result['Response']);
        $this->setAccessToken($response->access_token);
        $this->setUserId($response->user_id);
        $this->_expiresIn = $response->expires_in;
    }

    public function getLoginURL($permissionScope) {
        $this->_permissionScope = $permissionScope;

        $parameters = array(
            'client_id' => $this->_appId,
            'scope' => $this->_permissionScope,
            'redirect_uri' => $this->_redirectURI,
            'response_type' => 'code',
        );

        return $this->_authorizeURL . '?' . http_build_query($parameters);
    }

    public function __construct($appId, $appSecret = '', $redirectURI = '') {
        self::startSessionIfNecessary();

        $this->_restClient = new RestClient();

        $this->_appId = $appId;
        $this->_appSecret = $appSecret;
        $this->_redirectURI = $redirectURI;
    }

    private static function startSessionIfNecessary() {
        $sessionId = session_id();
        if(empty($sessionId))
            session_start();
    }

    public function getAccessToken() {
        if (empty($this->_accessToken)) {
            if (isset($_SESSION[$this->_sessionKey]['access_token'])) {
                $this->_accessToken = $_SESSION[$this->_sessionKey]['access_token'];
            }
        }
        return $this->_accessToken;
    }

    public function setAccessToken($accessToken) {
        $this->_accessToken = $accessToken;
        $_SESSION[$this->_sessionKey]['access_token'] = $accessToken;
    }

    public function getUserId() {
        if (empty($this->_userId)) {
            if (isset($_SESSION[$this->_sessionKey]['user_id'])) {
                $this->_userId = $_SESSION[$this->_sessionKey]['user_id'];
            }
        }
        return $this->_userId;
    }

    public function setUserId($userId) {
        $this->_userId = $userId;
        $_SESSION[$this->_sessionKey]['user_id'] = $userId;
    }

}