<?php
/**    
 * SocialBacklinks Config view LinkedIn layout
 *
 * We developed this code with our hearts and passion.
 * We hope you found it useful, easy to understand and change.
 * Otherwise, please feel free to contact us at contact@joomunited.com
 *
 * @package 	Social Backlinks
 * @copyright 	Copyright (C) 2012 JoomUnited (http://www.joomunited.com). All rights reserved.
 * @license 	GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
 */

defined( '_JEXEC' ) or die( );

JHtml::_( 'behavior.framework', true );

$doc = JFactory::getDocument( );
$doc->addStylesheet( JURI::root( true ) . '/media/com_socialbacklinks/css/' . SBHelpersEnv::getMediaFile( 'socialbacklinks.css' ) );
$doc->addStyleDeclaration( '
	.contentpane 
		{
		height: 90%;
		}
	.popup .nonactive
		{
		display: none;
		}
' );
$doc->addScript( JURI::root( true ) . '/media/com_socialbacklinks/js/' . SBHelpersEnv::getMediaFile( 'socialbacklinks.js' ) );

// Get configuration fields
if ($plugin->getOption('config_mode', 0) != 1) {
	$fields = "'config_mode'";
} else {
	if ( !$plugin->getOption('post_target', '') )
	{
		$fields = "'config_mode', 'api_key_public', 'api_key_private', 'post_target'";
	}
	else {
		$fields = "'config_mode', 'api_key_public', 'api_key_private', 'post_target', 'page_id'";
	}
}


$doc->addScriptDeclaration( "
document.addEvent('domready', function()
{
	var config = new SB.SocialConfig(
	{
		'wrapper': 'form',
		'single_block': 'form',
		
		'fields': Array( " . $fields . " ),
		'section': 'linkedin',
		
		'no_value_error_msg': '" . JText::_( 'SB_EMPTY_VALUE_ERROR', true ) . "',
		
		'ajax_error_msg': '" . JText::_( 'SB_OTHER_ERROR', true ) . "',
		'ajax_success_msg': '" . JText::_( 'SB_SAVED', true ) . "'
	});
	
	document.getElements('.post_target')
		.addEvent('click', function()
		{
			var radio_btn = this.getElement('input');
			if ( !radio_btn || ( radio_btn.get('type') != 'radio' ) ) {
				return true;
			}

			if ( radio_btn.value > 0 ) {
				config.options.fields = Array( 'config_mode', 'api_key_public', 'api_key_private', 'post_target', 'page_id' );

				$$('.advanced').removeClass('nonactive')
					.addClass('active');
			}
			else {
				config.options.fields = Array( 'config_mode', 'api_key_public', 'api_key_private', 'post_target' );

				$$('.advanced').removeClass('active')
					.addClass('nonactive');
			}
		});
	
	document.getElements('.config_mode').addEvent('click', function() {
		var radio_btn = this.getElement('input');
		if ( !radio_btn || ( radio_btn.get('type') != 'radio' ) ) {
			return true;
		}
		
		if ( radio_btn.value > 0 ) {
			config.options.fields = Array( 'config_mode', 'api_key_public', 'api_key_private', 'post_target' );
			$$('.basic').removeClass('nonactive')
				.addClass('active');
		} else {
			config.options.fields = Array( 'config_mode' );
			$$('.basic').removeClass('active')
				.addClass('nonactive');;
		}
		document.getElementById('post_target0').fireEvent('click');
	});
	
	
})
" );
?>
<div class="clr"></div>
<form action="index.php" method="post" name="adminForm" class="popup account-settings-wrapper">
	<div class="header-wrapper">
		<div class="header-text">
			<?php echo JText::sprintf( 'SB_ACCOUNT_SETTINGS', JText::_( 'SB_LINKEDIN' ) ) ?>
		</div>
		<div class="options-wrapper">
			<div class="save-button button">
				<span><?php echo JText::_( 'SB_SAVE') ?></span>
			</div>
		</div>
	</div>
	
	<div class="error-block"></div>
	
	<fieldset>
		<ul>
			<li>
				<label class="key" for="config_mode">
	                <?php echo JText::_( 'SB_CONFIG_MODE' ); ?>:
	            </label>
	            <div class="value radio-list">
	            	<?php $config_mode = ( !$plugin->getOption('config_mode', 0) ) ? 0 : 1; ?>
	            	<label for="config_mode0" class="radiobtn config_mode">
	            		<input type="radio" value="0" id="config_mode0" name="config_mode" 
							<?php echo ( $config_mode == 0 ) ? 'checked="checked"' : '' ?>
						/>
	            		<?php echo JText::_( 'SB_AUTO_MODE' ); ?>
	            	</label>
	            	<label for="config_mode1" class="radiobtn config_mode">
	            		<input type="radio" value="1" id="config_mode1" name="config_mode" 
							<?php echo ( $config_mode != 0 ) ? 'checked="checked"' : '' ?>
						/>
	            		<?php echo JText::_( 'SB_MANUAL_MODE' ); ?>
	            	</label>
	            </div>
			</li>
			<?php
			if ($config_mode) {
				$class = 'active';
			} else {
				$class = 'nonactive';
			}
			
			?>
			<li class="basic <?php echo $class; ?>">
				<label class="key" for="api_key_public">
	                <?php echo JText::_( 'SB_API_KEY' ); ?>:
	            </label>
	            <div class="value">
					<input type="text" id="api_key_public" name="api_key_public" maxlength="250"
						value="<?php echo ( !$plugin->getOption('api_key_public', false) ) ? '' : $plugin->getOption('api_key_public', null); ?>" />
				</div>
			</li>
			<li class="basic <?php echo $class; ?>">
                <label class="key" for="api_key_private">
                    <?php echo JText::_( 'SB_KEY_SECRET' ); ?>:
                </label>
	            <div class="value">
					 <input type="text" id="api_key_private" name="api_key_private" maxlength="250" 
					 	value="<?php echo ( !$plugin->getOption('api_key_private', false) ) ? '' : $plugin->getOption('api_key_private', null); ?>" />
	            </div>
	        </li>
	        <li class="basic <?php echo $class; ?>">
	            <label class="key" for="post_target">
	                <?php echo JText::_( 'SB_POST_TARGET' ); ?>:
	            </label>
	            <div class="value radio-list">
	            	<?php $post_target = ( !$plugin->getOption('post_target', false) ) ? 0 : $plugin->getOption('post_target', null); ?>
	            	<label for="post_target0" class="radiobtn post_target">
	            		<input type="radio" value="0" id="post_target0" name="post_target" 
							<?php echo ( $post_target == 0 ) ? 'checked="checked"' : '' ?>
						/>
	            		<?php echo JText::_( 'SB_TO_MY_PROFILE' ); ?>
	            	</label>
					<label for="post_target1" class="radiobtn post_target">
						<input type="radio" value="1" id="post_target1" name="post_target" 
							<?php echo ( $post_target == 1 ) ? 'checked="checked"' : '' ?>
						/>
						<?php echo JText::_( 'SB_TO_SELECTED_PAGE' ); ?>
					</label>
	            </div>
	         </li>
        <?php
        if ( !$post_target || $config_mode == 0 )
		{
			$class = 'nonactive';
		}
		else {
			$class = 'active';
		}
        ?>
	        <li class="advanced <?php echo $class ?>">
                <label class="key" for="page_id">
                    <?php echo JText::_( 'SB_PAGE_ID' ); ?>:
                </label>
	           <div class="value">
					 <input type="text" id="page_id" name="page_id" maxlength="250"
					 		value="<?php echo ( !$plugin->getOption('page_id', false) ) ? '' : $plugin->getOption('page_id', null); ?>" />
	            </div>
	        </li>
        </ul>
    </fieldset>
	
    <div class="ajax-loader"></div>
    <div class="ajax-overlay"></div>
</form>
