<?php
// namespace administrator\components\com_jmap\framework\files;
/**
 * @package JMAP::FRAMEWORK::administrator::components::com_jmap
 * @subpackage framework
 * @subpackage file
 * @author Joomla! Extensions Store
 * @copyright (C) 2015 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');

/**
 * Multilanguage fallback utility class
 * 
 * @package JMAP::FRAMEWORK::administrator::components::com_jmap
 * @subpackage framework
 * @subpackage files
 * @since 3.0
 */
class JMapFileSources extends JObject {
	/**
	 * Database connector
	 * 
	 * @access private
	 * @var Object
	 */
	private $dbo;
	
	/**
	 * Application object
	 *
	 * @access private
	 * @var Object
	 */
	private $app;
	
	/**
	 * Store uploaded file to cache folder,
	 * fully manage error messages and ask for database insert
	 * 
	 * @access public
	 * @return boolean 
	 */
	public function import() {
		// Get file info
		$file = $this->app->input->files->get('datasourceimport');
		$tmpFile = $file['tmp_name'];
		$tmpFileName = $file['name'];
		try {
			if(!$tmpFile || !$tmpFileName) {
				throw new JMapException(JText::_('COM_JMAP_NOFILE_SELECTED'), 'error');
			}
			
			$tmpFileSize = $file['size'];
			$allowedFileSize = 2 * 1024 * 1024; // MB->Bytes
			if($tmpFileSize > $allowedFileSize) {
				throw new JMapException(JText::_('COM_JMAP_SIZE_ERROR') .' Max 2MB.', 'error');
			}
			
			$tmpFileExtension = @array_pop(explode('.', $tmpFileName));
			if($tmpFileExtension != 'json') {
				throw new JMapException(JText::_('COM_JMAP_EXT_ERROR'), 'error');
			}

			// Deserialize contents
			$fileContents = file_get_contents($tmpFile);
			if($fileContents) {
				$objectToRestore = json_decode($fileContents);
			}
			
			if(!is_array($objectToRestore)) {
				throw new JMapException(JText::_('COM_JMAP_INVALID_IMPORT_DATA'), 'error');
			}
			
			// Prepare the values array
			$dbQueryArray = array();
			foreach ($objectToRestore as $dataSource) {
				$dbSourceArray = array();
				$dbSourceArray[] = $this->dbo->quote($dataSource->type);
				$dbSourceArray[] = $this->dbo->quote(strip_tags($dataSource->name));
				$dbSourceArray[] = $this->dbo->quote(strip_tags($dataSource->description));
				$dbSourceArray[] = (int)$dataSource->published;
				$dbSourceArray[] = $this->dbo->quote($dataSource->sqlquery);
				$dbSourceArray[] = $this->dbo->quote($dataSource->sqlquery_managed);
				$dbSourceArray[] = $this->dbo->quote($dataSource->params);
				
				// Source imploded assignment
				$dbQueryArray[] = implode(',', $dbSourceArray);
			}
			
			// Final sources imploded assignment
			$implodedSources = '(' . implode('),(', $dbQueryArray) . ')';
			
			$queryImport = 	"INSERT INTO" . $this->dbo->quoteName('#__jmap') .
						   	"\n (" .
						   	"\n" . $this->dbo->quoteName('type') . "," .
						   	"\n" . $this->dbo->quoteName('name') . "," .
						   	"\n" . $this->dbo->quoteName('description') . "," .
						   	"\n" . $this->dbo->quoteName('published') . "," .
						   	"\n" . $this->dbo->quoteName('sqlquery') . "," .
							"\n" . $this->dbo->quoteName('sqlquery_managed') . "," .
							"\n" . $this->dbo->quoteName('params') . ")" .
						   	"\n VALUES " . $implodedSources;
			$this->dbo->setQuery($queryImport);
			$this->dbo->execute();
			if($this->dbo->getErrorNum()) {
				throw new JMapException(JText::sprintf('COM_JMAP_DBERROR_IMPORT_DATA', $this->dbo->getErrorMsg()), 'error');
			}
		}
		catch(JMapException $e) {
			$this->setError($e);
			return false;
		} catch (Exception $e) {
			$jmapException = new JMapException($e->getMessage(), 'error');
			$this->setError($jmapException);
			return false;
		}
		
		return true;
	}

	/**
	 * Download uploaded file message
	 * 
	 * @access public
	 * @return boolean
	 */
	public function export($ids = null) { 
		// Load data from DB 
		try {
			$query = "SELECT * FROM #__jmap" .
					 "\n WHERE id IN ( " . implode(',', $ids) . ")";
			$this->dbo->setQuery($query);
			$resultInfo = $this->dbo->loadObjectList();
			if(!$resultInfo) {
				if(!$resultInfo) {
					throw new JMapException(JText::_('COM_JMAP_ERROR_NODATA_TOEXPORT'), 'error');
				}
			}
			
			// Serialize data to export
			$dataToExport = json_encode($resultInfo);
		} catch(JMapException $e) {
			$this->setError($e);
			return false;
		} catch (Exception $e) {
			$jmapException = new JMapException($e->getMessage(), 'error');
			$this->setError($jmapException);
			return false;
		}
		
		$fsize = strlen($dataToExport);
		$cont_dis = 'attachment';
		$mimeType = 'application/json';
		
		// required for IE, otherwise Content-disposition is ignored
		if (ini_get ( 'zlib.output_compression' )) {
			ini_set ( 'zlib.output_compression', 'Off' );
		}
		header ( "Pragma: public" );
		header ( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
		header ( "Expires: 0" );
		header ( "Content-Transfer-Encoding: binary" );
		header ( 'Content-Disposition:' . $cont_dis . ';' . ' filename="datasources.json";' . ' size=' . $fsize . ';' ); //RFC2183
		header ( "Content-Type: " . $mimeType ); // MIME type
		header ( "Content-Length: " . $fsize );
		if (! ini_get ( 'safe_mode' )) { // set_time_limit doesn't work in safe mode
			@set_time_limit ( 0 );
		}
		// No encoding - we aren't using compression... (RFC1945)
		//header("Content-Encoding: none");
		//header("Vary: none");
		echo $dataToExport;
		
		exit();
	}

	/**
	 * Class constructor
	 * 
	 * @access public
	 * @param Object $dbo
	 * @param Object $app
	 * @return Object &
	 */
	public function __construct($dbo, $app) {
		// DB connector
		$this->dbo = $dbo;
		
		// Application
		$this->app = $app;
	}
}